﻿/*
	VERSION:		1.95
	1.95		Added reset() to prevent inpending double-click
	1.94		Make "target" optional again
	1.93		Added auto-cleanup >>		Added doesTargetExist() check and automatic shutDown() when target movieClip no longer exists
	1.92		Added inline scope to setTimeouts
	1.91		Added a missing  _global.setTimeout
	
	
	NOTE:
		You can optionally specify a movieClip target.
		That way, only double-clicking that movieClip will trigger the double-click event.
		
		
	REMOVAL (auto):
		my_mc.removeMovieClip();
		delete doubleClick;
		// NEVER use unloadMovie()  because DoubleClick cannot auto-detect when movieClips are removed that way  (their internal data remains exactly the same)
		
		
	REMOVAL (manual):
		doubleClick.shutDown();
		delete doubleClick;
		
		
	USAGE 1:
		doubleClick = new DoubleClick();
		doubleClick.onDoubleClick = function()
		{
			trace("double click");
		}
		
		
	USAGE 1b:
		doubleClick = new DoubleClick( my_mc );
		doubleClick.onDoubleClick = function()
		{
			trace("double click");
		}
	
	
	USAGE 2:
		doubleClick = new DoubleClick();
		doubleClick.addListener( this );
		this.onDoubleClick = function()
		{
			trace("double click");
		}
*/
class DoubleClick
{
	var maxDistance = 16;						// pixels.  How close the 2 clicks need to be to each other
	var maxDelay = 1000/4.5;				// milliseconds.  How fast the double-click needs to be, to be valid
	var oldX:Number;
	var oldY:Number;
	var broadcastMessage:Function;	// Allows events to be broadcast
	var onDoubleClick:Function;			// externally-defined function
	var delay;											// ID number used to cancel the delay timeout
	var target;											// movieClip to be clicked on
	var hasTarget;									// Whether or not double-click requires hit-test with a specific movieClip to succeed
	var clickCount;									// keeps track of how many times you've clicked
	function DoubleClick( newTarget )
	{
		target = newTarget;
		hasTarget = Boolean( target !== undefined );
		AsBroadcaster.initialize( this );
		Mouse.addListener( this );
		oldX = 99999;
		oldY = 99999;
		clickCount = 0;
	}// CONSTRUCTOR
	function shutDown()
	{
		target = null;
		_global.clearTimeout( delay );
		Mouse.removeListener( this );
	}// PSEUDO-DESTRUCTOR		(does not remove the object)
	
	
	
	function onMouseUp()
	{
		var _this = this;
		
		if( doesTargetExist() === false ){
			shutDown();
			return;
		}// if:  target no longer exists
		
		// if this click is near the previous one  &  timeOut hasn't expired
		var isComponent = (target._name == "boundingBox_mc");
		var isEnabled = (isComponent) ? target._parent.enabled : true;		// component is enabled?
		var isVisible = (isComponent) ? target._parent.visible : true;		// component is visible?
		var targetClicked = (hasTarget) ? target.hitTest( _root._xmouse, _root._ymouse ) : true;
		if(targetClicked  &&  isEnabled  &&  isVisible)
		{// if:  target clicked
			clickCount++;
			
			
			if(clickCount == 1)
			{// if:  1st click
				// remember this click location
				oldX = _root._xmouse;
				oldY = _root._ymouse;
				// start waiting for double-click
				_global.clearTimeout( delay );
				delay = _global.setTimeout( function(){
					_this.timeOut();
				}, maxDelay );		// calls timeOut() 1/4 of a second later
			}// if:  1st click
			
			
			if(clickCount == 2)
			{// if:  2nd click
				// remember this click location
				var newX = _root._xmouse;
				var newY = _root._ymouse;
				// check distance
				var diffX = newX - oldX;
				var diffY = newY - oldY;
				oldX = 99999;
				oldY = 99999;
				var clickDistance = Math.sqrt( (diffX*diffX) + (diffY*diffY) );
				if( clickDistance < this.maxDistance )
				{// if:  near the location of the 1st click
					// announce
					var doDoubleClick = function(){
						_this.onDoubleClick();
						_this.broadcastMessage( "onDoubleClick" );
						// wait to enable double-clicking again
						_global.clearTimeout( _this.delay );
						_this.delay = _global.setTimeout( function(){
							_this.timeOut();
						}, _this.maxDelay );		// calls timeOut() 1/4 of a second later
					}// doDoubleClick()
					_global.setTimeout( function(){
						doDoubleClick();
					}, 1 );
				}// if:  near the location of the 1st click
			}// if:  2nd click
		}// if:  target clicked
		else
		{// if: target not clicked
			clickCount = 0;
		}// if: target not clicked
	}// click()
	
	
	
	function reset()
	{
		if( doesTargetExist() === false ){
			shutDown();
			return;
		}// if:  target no longer exists
		
		clickCount = 0;
	} // reset()
	
	
	
	function timeOut()	{
		reset();
	}// timeOut()
	
	
	
	function doesTargetExist()
	{
		if( !hasTarget )		return true;		// If not looking for any particular movieCLip,  then always succeed
		
		if( target._currentframe !== undefined )		return true;
		// else
		trace("DoubleClick detected missing target");
		return false;
	}// doesTargetExist()
}// DoubleClick
